local BOXES_COUNT = 4

function createArtifactsPreview(self)
    for _,artifact in ipairs(self.artifactsPreview) do
        artifact:Destroy()
    end
    local boxNumber = 1
    for id, artifact in ipairs(self.detector.Artifacts) do
        local artifactFlag = bit.lshift(1, id-1)
        if AND(self.detector.ArtifactsOwned, artifactFlag) ~= 0 then
            local box = self.boxes[boxNumber]
            self.artifactsPreview[boxNumber] = CreateHUDObject{
                X = box.X,
                Y = box.Y,
                Z = box.Z + 1,
                logic = "AniCycle",
                image = artifact.Image
            }
            self.artifactsPreview[boxNumber].DrawFlags.NoDraw = true
            if boxNumber < BOXES_COUNT then
                boxNumber = boxNumber + 1
            else
                break
            end
        end
    end
end

function main(self)
    if self.State == 0 then
        self.Flags.AlwaysActive, self.DrawFlags.NoDraw = true, true
        self.boxes = { }
        self.artifactsPreview = { }
        self.detector = GetObject(3206)
		self.State = 101
	end

    if self.State == 101 then
        self.timeDelay = GetTime() + 1200
        self.State = 1
    end

    if self.State == 1 and not KeyPressed"Enter" and GetTime() > self.timeDelay then
        local width, height = self.detector.ScreenW, self.detector.ScreenH
        local startY = math.ceil(height/2) - 64
        local dY = 64
        local boxX = width - 24

        for n = 1, BOXES_COUNT do
            self.boxes[n] = CreateHUDObject{
                X = boxX,
                Y = startY + n*dY - dY,
                Z = 12500,
                logic = "DoNothing",
                image = "CUSTOM_SELECT_BOX"
            }
            self.boxes[n].DrawFlags.NoDraw = true
        end

        self.lastlyOwnedArtifacts = self.detector.ArtifactsOwned
        createArtifactsPreview(self)

        self.State = 2
    end

	if self.State == 2 and KeyPressed"Enter" then
        for _,box in ipairs(self.boxes) do
            box.DrawFlags.NoDraw = false
        end
        if self.lastlyOwnedArtifacts ~= self.detector.ArtifactsOwned then
            createArtifactsPreview(self)
            self.lastlyOwnedArtifacts = self.detector.ArtifactsOwned
        end
        for _,artifact in ipairs(self.artifactsPreview) do
            artifact.DrawFlags.NoDraw = false
        end

        self.State = 3
    end


	if self.State == 3 and not KeyPressed"Enter" then
        for _, artifact in ipairs(self.artifactsPreview) do
            artifact.DrawFlags.NoDraw = true
        end
        for _,box in ipairs(self.boxes) do
            box.DrawFlags.NoDraw = true
        end
        self.State = 2
    end

end


